import okhttp3.*
import java.io.IOException

class CheckOrderStatusSDK(private val baseUrl: String) {

    fun checkOrderStatus(userToken: String, orderId: String, callback: CheckOrderStatusCallback) {
        val client = OkHttpClient()

        val requestBody = FormBody.Builder()
            .add("user_token", userToken)
            .add("order_id", orderId)
            .build()

        val request = Request.Builder()
            .url(baseUrl + "/api/check-order-status")
            .post(requestBody)
            .build()

        client.newCall(request).enqueue(object : Callback {
            override fun onFailure(call: Call, e: IOException) {
                callback.onFailure(e.message ?: "Network error")
            }

            override fun onResponse(call: Call, response: Response) {
                val body = response.body()?.string()

                if (response.isSuccessful && body != null) {
                    // Parse the JSON response and extract data
                    try {
                        val jsonResponse = JSONObject(body)
                        val status = jsonResponse.optString("status")
                        val message = jsonResponse.optString("message")

                        if (status == "COMPLETED") {
                            val result = jsonResponse.getJSONObject("result")
                            val txnStatus = result.optString("txnStatus")
                            val resultInfo = result.optString("resultInfo")
                            val orderId = result.optString("orderId")
                            val successResponse = SuccessResponse(txnStatus, resultInfo, orderId)
                            callback.onSuccess(successResponse)
                        } else {
                            callback.onFailure(message)
                        }
                    } catch (e: JSONException) {
                        callback.onFailure("Error parsing JSON")
                    }
                } else {
                    callback.onFailure("Error: ${response.code()}")
                }
            }
        })
    }
}

data class SuccessResponse(val txnStatus: String, val resultInfo: String, val orderId: String)

interface CheckOrderStatusCallback {
    fun onSuccess(response: SuccessResponse)
    fun onFailure(error: String)
}
