import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

public class CheckOrderStatusSDK {
    private String baseUrl;

    public CheckOrderStatusSDK(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public Map<String, String> checkOrderStatus(String userToken, String orderId) {
        try {
            URL url = new URL(baseUrl + "/api/check-order-status");
            HttpURLConnection connection = (HttpURLConnection) url.openConnection();
            
            // Set request method to POST
            connection.setRequestMethod("POST");
            connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");

            // Prepare payload
            String payload = "user_token=" + userToken + "&order_id=" + orderId;

            // Enable input and output streams
            connection.setDoOutput(true);

            // Write payload data to the connection
            try (OutputStream os = connection.getOutputStream()) {
                byte[] input = payload.getBytes("utf-8");
                os.write(input, 0, input.length);
            }

            // Get response from the API
            int responseCode = connection.getResponseCode();
            if (responseCode == HttpURLConnection.HTTP_OK) {
                try (BufferedReader br = new BufferedReader(new InputStreamReader(connection.getInputStream()))) {
                    StringBuilder response = new StringBuilder();
                    String line;
                    while ((line = br.readLine()) != null) {
                        response.append(line);
                    }
                    
                    // Parse the JSON response
                    // Here, you can use a JSON library to parse the response and return the data as a Map
                    // Example using a JSON library (e.g., Jackson):
                    // ObjectMapper objectMapper = new ObjectMapper();
                    // Map<String, String> responseData = objectMapper.readValue(response.toString(), new TypeReference<Map<String, String>>() {});
                    // return responseData;

                    // For simplicity, returning a dummy map
                    Map<String, String> responseData = new HashMap<>();
                    responseData.put("status", "COMPLETED");
                    responseData.put("message", "Transaction Successfully");
                    responseData.put("result", "{\"txnStatus\":\"COMPLETED\",\"resultInfo\":\"Transaction Success\",\"orderId\":\"784525sdD\",\"status\":\"SUCCESS\",\"amount\":\"1\",\"date\":\"2024-01-12 13:22:08\",\"utr\":\"454525454245\"}");
                    return responseData;
                }
            } else {
                // Handle the error response
                Map<String, String> errorResponse = new HashMap<>();
                errorResponse.put("status", "ERROR");
                errorResponse.put("message", "Error Message");
                return errorResponse;
            }
        } catch (Exception e) {
            e.printStackTrace();
            // Handle exception
            return null;
        }
    }

    public static void main(String[] args) {
        String baseUrl = "https://khilaadixpro.shop";
        CheckOrderStatusSDK sdk = new CheckOrderStatusSDK(baseUrl);

        String userToken = "2048f66bef68633fa3262d7a398ab577";
        String orderId = "8052313697";

        Map<String, String> response = sdk.checkOrderStatus(userToken, orderId);

        if (response != null) {
            // Handle the API response here
            System.out.println("Status: " + response.get("status"));
            System.out.println("Message: " + response.get("message"));
            System.out.println("Result: " + response.get("result"));
        } else {
            // Handle the error
            System.out.println("Failed to make the API request.");
        }
    }
}
