from flask import Flask, request, jsonify

app = Flask(__name__)

@app.route('/webhook', methods=['POST'])
def webhook():
    data = request.form
    status = data.get('status')
    order_id = data.get('order_id')
    remark1 = data.get('remark1')

    if status == 'SUCCESS':
        # Process the data here as needed
        # For example, log it or perform other actions
        print(f"Received SUCCESS status for order {order_id}")
        return "Webhook received successfully"
    else:
        # Respond with an error message if the status is not "SUCCESS"
        return jsonify({"error": f"Invalid status: {status}"}), 400

if __name__ == '__main__':
    app.run(debug=True)
