<?php
//every 1day 0 0,12 * * *
// Define the base directory constant
define('PROJECT_ROOT', realpath(dirname(__FILE__)) . '/../');

// Securely include files using the PROJECT_ROOT constant
include PROJECT_ROOT . 'pages/dbFunctions.php';
include PROJECT_ROOT . 'auth/config.php';

date_default_timezone_set("Asia/Kolkata");

// Set maximum execution time to 5 minutes (300 seconds)
ini_set('max_execution_time', 300);

$payzero4_current_time = date("Y-m-d H:i:s");

// Calculate time threshold (1 hour ago)
$payzero4_time_threshold = date("Y-m-d H:i:s", strtotime('-1 hour'));

// SQL query to fetch orders with create_date more than 1 hour older than current time and status is PENDING
$payzero4_sql = "SELECT order_id, user_token, create_date FROM orders WHERE create_date <= '$payzero4_time_threshold' AND status = 'PENDING'";

$payzero4_result = $conn->query($payzero4_sql);

if ($payzero4_result->num_rows > 0) {
    // Update orders status to FAILURE
    while ($payzero4_row = $payzero4_result->fetch_assoc()) {
        $payzero4_order_id = $payzero4_row["order_id"];
        $payzero4_user_token = $payzero4_row["user_token"];
        // Update status to FAILURE
        $payzero4_update_sql = "UPDATE orders SET status = 'FAILURE' WHERE order_id = '$payzero4_order_id'";
        if ($conn->query($payzero4_update_sql) === TRUE) {
            echo "Order ID: $payzero4_order_id marked as FAILURE.\n";
        } else {
            echo "Error updating record: " . $conn->error . "\n";
        }
    }
} else {
    echo "No orders found with create_date more than 1 hour older than current time.\n";
}