const express = require('express');
const bodyParser = require('body-parser');

const app = express();
app.use(bodyParser.urlencoded({ extended: true }));

app.post('/', (req, res) => {
    const { status, order_id, remark1 } = req.body;

    if (status === 'SUCCESS') {
        // Process the data here as needed
        // For example, log it or perform other actions
        console.log(`Order ID: ${order_id}, Remark1: ${remark1}`);

        res.send('Webhook received successfully');
    } else {
        res.status(400).send(`Invalid status: ${status}`);
    }
});

app.use((req, res) => {
    res.status(400).send('Invalid request method');
});

const PORT = process.env.PORT || 3000;
app.listen(PORT, () => {
    console.log(`Server is running on port ${PORT}`);
});
